import socket

class LAN_Controller:

    def __init__(self, hostname, port=5025):
        self.hostname = hostname
        self.port = port
        self.connect()

    def __del__(self):
        self.disconnect()

    def connect(self):
        print "Connecting to Instrument..."
        self.s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        self.s.connect((self.hostname, self.port))
        
        resp = self.query('*IDN?',verbose=False)
        print resp[:-1]
        print "Instrument Connected"

    def disconnect(self):
        self.s.close()

    def command(self, CMD,verbose=False):
        self.s.send((CMD+'\n').encode())
        if verbose:
            print "Command Sent: " + CMD

    def getResponse(self,verbose=False):
            out = self.s.recv(1024)#.decode().strip()
            if verbose:
                print "Response String: " + out
            return out

    def query(self, CMD, show_response = True, verbose=False):
        self.command(CMD,verbose)
        if verbose:
            print 'Waiting...'
        out = self.getResponse(verbose)
        return out
